/*
 * @(#)User.java 
 *
 * 
 * programma componente server chat java
 * 
 * di Jonathan Di Nardo
 * 
 *
 */



import java.net.*;
import java.io.*;
import java.util.*;

public class User implements Runnable{
	
Socket sock;
BufferedReader in;
PrintWriter out;
public static Vector utenti;

// le costanti sono comandi speciali

final String NICKREQUIRED = "NICK_RQ";
final String CHANGENICK   = "NICKCHG";
final String WHO_IS		  = "WHO_ISU";
final String PRIVATEMSG   = "PRIVATE";
final String CLOSE        = "CLOSE_W";
final String EXIT_USR	  = "CLOSE_U";
							 
final String ERROR_NICK ="#->NICK_EXIST";

boolean stop = false;		 
Thread mio;
private String nick ="";
String welcome[] = {
										
					"BENVENUTO IN CHAT",
					" ",
					"SEI ORA COLLEGATO CON IL SERVER",
					" ",
					"SPECIFICARE IL NICK PER ENTRARE",
					
					};
	
public User(Socket a){
	
	

	try {
			
		sock = a;	
		in = new BufferedReader(new InputStreamReader(sock.getInputStream()));
		out = new PrintWriter(sock.getOutputStream(),true);	
		
		//INVIA IL TESTO DI BENVENUTO
		
		
		for (int n=0;n<welcome.length;n++) out.println(welcome[n]);
		
			out.println("UTENTI COLLEGATI: " + utenti.size());
				
		stop = false;
		start();
		
		
		
		
	} catch (IOException e) {
		
		e.printStackTrace();
		
		}
	
	}

// INVIA UN TESTO AD UN SINGOLO UTENTE

static public void prvChat(String pvtNick,String pvtMessage) {
			
		for (int n=0;n<utenti.size();n++){
		
			User tmp = (User)utenti.elementAt(n);	
			
			if (tmp.nick.equals(pvtNick)) {
				
				try {
									
					PrintWriter outp = new PrintWriter(tmp.sock.getOutputStream(),true);
					if (!pvtMessage.equals("")) outp.println(pvtMessage);		
					
					} catch (IOException e) {
						
						e.printStackTrace();
						
						}
					
			}
							
		}		
}


//RIMUOVE UN UTENTE SPECIFICO DALLA CHAT


static public void removeUser(String pvtNick) {
	
	pubChat("L'utente " + pvtNick + " si  disconnesso");
	
	for (int n=0;n<utenti.size();n++){
		
			User tmp = (User)utenti.elementAt(n);
			if (tmp.nick.equals(pvtNick)) {
				
				utenti.removeElementAt(n);
				tmp.exit();
				tmp = null;
				
				}			
			
		}
		
	
	nickRefresh();
	
	}
	
	
// INVIA UN MESSAGGIO A TUTTI GLI UTENTI COLLEGATI

static public void pubChat(String msg) {
	
		for (int n=0;n<utenti.size();n++){
				
		User tmp = (User)utenti.elementAt(n);	
		PrintWriter outp = tmp.out;
		if (!msg.equals("")) outp.println(msg);
		
		}
	
	
	}

//RESTITUISCE UN UTENTE CON IL NICK SPECIFICATO

static public User users(String nick) {
	
	User tmp = null;
	User result = null;
	for (int n=0;n<utenti.size();n++){
				
		tmp = (User)utenti.elementAt(n);	
		if (tmp.nickName().equals(nick)) result = tmp;
							
		}		
		
	
	return result;
	
	}
	
//RESTITUISCE IL NICK DI QUESTO UTENTE

public String nickName(){
	
	return nick;
	
	}
	
//AGGIORNA LA LISTA NEI NICK PER TUTTI GLI UTENTI
	
static private void nickRefresh() {
	
	pubChat("->NICK_ST");
	
	for (int u=0;u<utenti.size();u++){
								
	   User temp = (User)utenti.elementAt(u);	
	   
	   if (temp.nickName().length()>0) pubChat(temp.nickName());
			
	 }
	 
	pubChat("NICK_ST<-");
	
	}
	
// CHIUDE LA CONNESSIONE DI UN UTENTE
	
public void exit(){
	
	stop = true;		  		
	mio = null;
	
	try {
		
		sock.close();
		
	} catch (IOException e) {
		
		e.printStackTrace();
		
		}
	
	}
	
public void start(){
	
	mio = new Thread(this);
	mio.start();
		
	}
	

public void run(){
	
	
	
	while (!stop && sock!=null) {
		
		try {
	
			String sr = in.readLine();		
			
			String cmd = "";
			
							
				if (sr.length()>2) if (sr.substring(0,2).equals("/:")) {
				
					
					cmd = sr.substring(2,9);				
					
					//CONTROLLO E NOTIFICA ENTRATA IN CHAT
					
					if (cmd.equals(CHANGENICK) && nickName()=="" ) {
						
						
						String status = "E' appena entrato ";
						
						String nick2 = sr.substring(10,sr.length());
						status = status + nick2;
					
						sr = null;
						
						if (users(nick2)==null) {			
												
							out.println("->NICKNOTIFY");
							out.println(nick2);
							nick = nick2;
							cmd = NICKREQUIRED;					
						
						} else 	{
							
								
								status = "#->NICK_EXIST";
								out.println(ERROR_NICK);
								status ="";
									
								}
							
						
						pubChat(status);
												
						}
						
					//CHIUSURA CHAT PRIVATA DI DUE UTENTI
					
					if (cmd.equals(CLOSE)) {
						
						String n = in.readLine();
						
						prvChat(nickName(),"CLOSE<-");	
						prvChat(nickName(),n);						
						
						prvChat(n,"CLOSE<-");
						prvChat(n,nickName());	
						
						sr = null;
						
						}
						
					//USCITA DALLA CHAT DI UN UTENTE
						
					if (cmd.equals(EXIT_USR)) {
						
						removeUser(nickName());
						sr = null;
						
						}
						
					//MESSAGGIO PRIVATO	
						
					if (cmd.equals(PRIVATEMSG)) {
						
						String n = in.readLine();
						String m = "<" + nickName() + ">" + in.readLine();
						prvChat(n,"PRIVATE<-");
						prvChat(n,nickName());
						prvChat(n,m);
						sr = null;
					
						
						}		
						
					//RICHIESTA CONNESSIONE PRIVATA
						
					if (cmd.equals(WHO_IS)) {
						
						cmd = sr.substring(10,sr.length());	
											
						
							User tmp = users(cmd);	
							
							if (!(tmp == null)) {
								
								prvChat(cmd,"->PRIVATE");
								prvChat(cmd,nickName());
								
								prvChat(nickName(),"->PRIVATE");
								prvChat(nickName(),cmd);
								sr = null;
							
							}
								
						
					}
						
					// AGGIORNAMENTO LISTA NICK
					
					if (cmd.equals(NICKREQUIRED)) {
						
							nickRefresh();		
						
						sr = null;
						
					}
				}
				
											
				if (sr != null) {
					 
					pubChat("<" + this.nickName() + ">" + sr);
				
						
					}
						
	
		  } catch (IOException e) {	
				
				removeUser(nickName());
		
		 	}
		 	
		}
	 
	
	}
}
